/******************************************************************************
// JsrLineIn.java:    
 * to simplify display/accept logic for debugging.
 * Sample Use:
 * import JsrLineIn;                  ... 
 * JsrLineIn file1 = new JsrLineIn();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * while (0 <= file1.read(strfile1[]))
      {   process records from strfile1[1];           }
*/

import java.io.*;

public class JsrLineIn
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  int                   recNum = 0;
  String                fileName = "";
//1.0  DataInputStream       inFileStream;
//1.0  DataInput             inFile;
  BufferedReader             inFile;

  JsrSysout sysout = new JsrSysout();

  public JsrLineIn()  // null constructor
  {
  }

  int open(String parmName)   
  {
     if (recNum != 0)
     {
        close();
     }
     sysout.display("Open   Input: " + parmName);   
     // open code here
     fileName = parmName;
     recNum = 0;

//1.0     try {inFileStream =
//1.0             new DataInputStream(new FileInputStream ( fileName));
//1.0          inFile =  inFileStream;
     try {inFile = new BufferedReader(new InputStreamReader
                                     (new FileInputStream ( fileName)),1000000);
         } catch (FileNotFoundException eFNF)
                 {System.out.println("FileNotFound: " + fileName);
                  recNum=-1; 
                 } 
     return recNum;
  } 
  int close()   
  {  
     sysout.display("Close  Input: " + fileName + " Records in=" + recNum
                   +"                          ");   
     if (recNum >= 0)
     {
//1.0  try {inFileStream.close();   // free up resource
       try {inFile.close();   // free up resource
           }catch ( IOException  eIO )
                  {System.out.println("I/OError! "   + fileName); }
     }
     recNum   = - recNum;
     fileName = "";
     return recNum;
  } 
  int read(String nameRecord[])   
  {
     // sysout.display("Read: " + nameRecord[0]);   
     if (!nameRecord[0].equals(fileName))
     {
        open(nameRecord[0]);
     }
     if (recNum >= 0)
     {
       try {nameRecord[1] = inFile.readLine();
           } 
             catch ( IOException  eIO )
                   {System.out.println("I/OError! "   + fileName); }
       if (nameRecord[1] == null)
          close();
       else
          recNum++;
     }
     // sysout.display ("recNum="+recNum+ "Rec="+ nameRecord[1]);
     return recNum;
  } 
} 

