    import java.io.*;
/** Java's way of doing the C "system" command.
  */
    public class JsrRunExec
    {
        static JsrSysout sysout = new JsrSysout();
        
/** run xyz command (for example: "start xyz.htm").
  */
        public static void runExec(String xyz)
        
        {
            // RunExec the ls command running
            sysout.display("JsrRunExec: " + xyz
                          +": "+ System.getProperty("os.name")
                          +": "+ System.getProperty("os.arch")
                          +": "+ System.getProperty("os.version")
                          );
            Runtime runtime = Runtime.getRuntime();
            try
            {
              Process proc = runtime.exec(xyz);
              // put a BufferedReader on the ls output
              InputStream inputstream =
                  proc.getInputStream();
              InputStreamReader inputstreamreader =
                  new InputStreamReader(inputstream);
              BufferedReader bufferedreader =
                  new BufferedReader(inputstreamreader);
              // read the output
              String line;
              while ((line = bufferedreader.readLine()) 
                          != null)
              {
                  if (line.length() > 0)
                      sysout.display("JsrRunExec: "+line+"*");
              }

              // check for ls failure
              try
              {
                  if (proc.waitFor() != 0)
                  {
                      sysout.display("JsrRunExec: exit value = " +
                          proc.exitValue());
                  }
              }
              catch (InterruptedException e) {
                  sysout.display("JsrRunExec: " + e);
              }
            }
            catch (IOException e) {
                sysout.display("JsrRunExec: " + e);
            }
        }
    
    
        public static void main(String[] args) 
            throws IOException
            {
                if (args.length != 1)
                {
                    System.out.println("missing RunExec Object");
                    System.exit(1);
                }
            runExec(args[0]);
        }
    }