import java.sql.*;

public class Describe {

  static final String DBHOST = "localhost";
  static Connection   conn; // one Connection per Class
  static Statement    stmt; // one Statement  per Class
  static String dataBaseName = "*";
  static int       tableNum = 0;
  static String[]  tableName;
  static JsrUtil           u = new JsrUtil();

  ResultSet results;
  JsrSysout sysout = new JsrSysout();
  
  String          sql = "";
  int       tableRow  = 0;  // # of fields in a table
  int       rowCount  = 0;  // # of rows with values in a table.
  String    type;
  int                i = 0;
  int       firstParen = 0;
  int        lastParen = 0;
  String[]   fieldName;
  String[]   fieldType;
  String[]   fieldLen;
  String[]   rowValue; 
  public static void main(String[] args)
  {
    Describe describe = new Describe();
    describe.init(args);
  }

  public void init(String[] parm)
  {
    sysout.syslog("syslogDescribe.txt");

    sysout.display("Value for     BIT="+java.sql.Types.BIT);
 // sysout.display("Value for    BOOL="+java.sql.Types.BOOL);  this is invalid type.
    sysout.display("Value for TINYINT="+java.sql.Types.TINYINT);
    sysout.display("Value for    CHAR="+java.sql.Types.CHAR);
    sysout.display("Value for VARCHAR="+java.sql.Types.VARCHAR);;

    

    if (parm.length > 0)    dataBaseName = parm[0];
    else System.exit(4);

    getTables(dataBaseName);

    for (i=0; i < tableNum; i++)
    {
      sysout.display( "# Fields in "+ tableName[i]+": "+
                            getFields(tableName[i]) );
      sysout.display(
                                 "Row Len " 
                    + u.padLeft ("Type",   8) + " "
                    //+ u.padRight("Null",   5)
                    //+ u.padRight("Key",    4)
                    //+ u.padRight("Default",8)
                    + u.padRight("Field", 20)
                    //+ u.padRight("Extra", 15)
                    );

      for (int i=0; i < fieldName.length; i++)
        sysout.display
        (  u.padLeft ((i+1)       , 3) + " "
         + u.padLeft (fieldLen [i], 3) + " " 
         + u.padLeft (fieldType[i], 8) + " "
         //+ u.padRight(getString(3), 5) 
         //+ u.padRight(getString(4), 4) 
         //+ u.padRight(getString(5), 8) 
         + u.padRight(fieldName[i],20) 
         //+ u.padRight(getString(6),15)
        );

       setSelectAll();
       int j = 1;
       while ( setNextRow() )
       {
            sysout.display("---Row: " + j++ + " of " + rowCount +"---");
            String [] tempString = getRowValues();
            for (int k=0; k < tableRow; k++)
                sysout.display(u.padLeft(fieldName[k]+"=",20)+tempString[k] ); 
       }
    }

    close();
  }

  public void setSelectAll()
  {
       try
       {
         sql = "SELECT COUNT(*) FROM " + tableName[i];
         results = stmt.executeQuery(sql);
         results.next();  // get count results;
         rowCount = results.getInt(1);
         sql = "SELECT * FROM " + tableName[i];
         sysout.display(u.getDateTime() + " setSelectAll executeQuery: " + sql);
         results = stmt.executeQuery(sql);
       }
       catch (SQLException E)
       {  sysout.display(u.getDateTime() + " setSelectAll SQL exception: " + E.getMessage()
                        +" in: "+sql);
       }

  }

  public boolean setNextRow()
  {
       boolean isNext = false;
       try
       {
          isNext = results.next();
       }
       catch (SQLException E)
       {  sysout.display(u.getDateTime() + " getValues SQL exception: " + E.getMessage());
       }
       return isNext;

  }

  public String[] getRowValues()
  {
    for (int k=0; k < tableRow; k++) rowValue[k] = getString(k+1);
    return rowValue;

  }


  public String[] getNames()
  {
    return fieldName;
  }

  public int getFields(String tableName)
  {
    try
    {
      sql = "DESCRIBE " + tableName;
      // 1=Field, 2=Type, 3=Null, 4=Key, 5=Default, 6= Extra

      sysout.display(u.getDateTime() + " getFields executeQuery: " + sql);
      results = stmt.executeQuery(sql);
      tableRow = 0;
      while ( results.next() )
      {
        tableRow++;
      }
      //sysout.display( "# Fields in "+ tableName+": "+tableRow );
      fieldName = new String[tableRow];
      fieldType = new String[tableRow];
      fieldLen  = new String[tableRow];
      rowValue  = new String[tableRow];
      results = stmt.executeQuery(sql);
      int i = 0;
      while ( results.next() )
      {
         fieldName[i] = getString(1);
                 type = getString(2);
           firstParen = type.indexOf ("(");
            lastParen = type.indexOf (")");
        fieldLen  [i] = type.substring(firstParen+1,lastParen);
        fieldType [i] = type.substring(0,firstParen);
        
        i++;
      }
    }
    catch (SQLException E)
    {  sysout.display(u.getDateTime() + " getFields SQL exception: " + E.getMessage());
    }
    return tableRow;
  }

  private String getString(int colNum)
  {
    String fixResult;
     try
     {
        fixResult = results.getString(colNum);
     }
     catch (SQLException E)
     {  sysout.display(u.getDateTime() + " getString SQL exception: " + E.getMessage());
        fixResult = " ";
     }
     
     if (fixResult == null)
         fixResult = "NULL";
     return fixResult;
  }

  public String[] getTables(String dbName)
  {
    if (tableNum == 0) connect(dbName);
    try
    {
     
      sql = "SHOW TABLES";
      // 1=Field, 2=Type, 3=Null, 4=Key, 5=Default, 6= Extra

      sysout.display(u.getDateTime() + " get Tables executeQuery: " + sql);
      results = stmt.executeQuery(sql);
      tableNum = 0;
      while ( results.next() )
      {
        tableNum++;
      }
      sysout.display( "# Tables in "+ dbName+": "+tableNum );
      tableName = new String[tableNum];
      results = stmt.executeQuery(sql);
      i = 0;
      while ( results.next() )
      {
        tableName[i] = getString(1);
        sysout.display((i+1)+" "+tableName[i]);
        i++;
      }
    }
    catch (SQLException E)
    {  sysout.display(u.getDateTime() + " getTables SQL exception: " + E.getMessage());
        
    }
    return tableName;
  }

  public void connect(String dbName)
  {
    try
    {
      Class.forName("org.gjt.mm.mysql.Driver");
    }

    catch (Exception E) {sysout.display(u.getDateTime() + " Unable to load driver"); E.printStackTrace();}

    try
    {
      String jdbcConnect = "jdbc:mysql://" + DBHOST + "/" + dbName;
      sysout.display(u.getDateTime() + " Getting Connection: "+jdbcConnect);
      conn = DriverManager.getConnection (jdbcConnect);
      sysout.display(u.getDateTime() + " create Statement");
      stmt = conn.createStatement();
    }
    catch (SQLException E)
    {  sysout.display(u.getDateTime() + " connect SQL exception: " + E.getMessage());
       System.exit(4);
    }
  }

  public void close()
  {
    try
    {
      results.close();
      stmt.close();
      conn.close();
    }
    catch (SQLException E) {sysout.display(u.getDateTime() + " close SQL exception: " + E.getMessage()); }
  }

}