
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DataUpdate {

  JsrSQL       sql;
  JsrSQL       sqlWho;
  static JsrUtil u = new JsrUtil();
  JsrSysout sysout = new JsrSysout();
  int[]      colSize;
  String[]   colName;  int c=0;          int lastCol = 0;
  String[]  rowValue;  int f=0; int r=0; int lastRow = 0;
  String[]  newRowValue;
  String      select;
  String       whoID = "";
  String    lastName = "";
  String   firstName = "";
  JTextField displayName;
  
   int    gridy = 2; // keep count of screen lines.
   
   JFrame frame;
   Container container;
   GridBagLayout gridbag;
   GridBagConstraints constraint; 

   JTextField [] colValue;
   JLabel     [] colLabel;
   JButton   nextRow    = new JButton("Next");
   JButton   updateRow  = new JButton("Update");
   JButton   addRow     = new JButton("Add New Person");
   JButton   deleteRow  = new JButton("Delete");
   JTextField findName  = new JTextField("");
   String[]   fileNames;

   JComboBox    tbNames; //after sql read line 180++ = new JComboBox(fileNames);
   String       tbName  = "Who"; // name selected from box.  
   JLabel copyResult; // define here so can use in Listener invoked methods.
   // Font defaultFont = new Font("Lucida Sans",Font.BOLD,18);        
   Font defaultFont = new Font("Comic Sans MS",Font.BOLD,18);
   Font labelFont   = new Font("Comic Sans MS",Font.BOLD,14);
   ActionListener parmAL = new ColValueAL();
   ActionListener buttonAL = new ButtonAL();
  
  
   //  A simple WindowClosing Listener
   class WindowExit extends WindowAdapter
   {
       public void windowClosing(WindowEvent e)
       {
          Window w = e.getWindow();
          w.setVisible(false);
          w.dispose();
          closeAndExit();
      }
   }// end class WindowExit
    // Note: this must be defined physically in the class
    //       BEFORE the first reference.  When I defined it at
    //       the end, it was not found, I moved it up here, all OK!

    
   class ColValueAL implements ActionListener
   {
     public void actionPerformed(ActionEvent ex)
     {
       String text = ex.getActionCommand();
       Object source = ex.getSource();
       // sysout.display(source+"/"+text);
       if (source == displayName)
       {
          select  = "Who WHERE LastName >= '"+ displayName.getText()
                  + "' ORDER BY LastName,FirstName";
          lastRow = sqlWho.setSelect(select);
          nextWho();         
       }
       else
       for (int i=0; i < colName.length; i++)
       {
          if (source == colValue[i])  // to find WHICH column was updated. 
          {
             //sysout.display(parmNumMinusOne+"==?/"+i+"/"+parmTitle[i]+"="+text);
             newRowValue [i] = text;
             copyResult.setText(colName[i]+": "+text);
             if (i == lastCol)
             {
                nextRow.requestFocus();
                //sysout.display("Focus on nextRow");
             }
             else
             {
                colValue[i+1].requestFocus();


                colValue[i+1].selectAll();
             }
          }
       }
       
     }
   } // end class ColValueAL


   class ButtonAL implements ActionListener
   {
     public void actionPerformed(ActionEvent ex)
     {
       Object source = ex.getSource();
       //sysout.display(source+);
       if (source == nextRow)
       {
          sysout.display("Next Row Button Pressed");     
          nextWho();
       }
       
       if (source == updateRow)
       {
          sysout.display("Update Row Button Pressed");
          for (int i = 2; i < colName.length; i++)
          {
             if (! colValue[i].getText().equals(newRowValue[i]))
             {
             
             sysout.display("No Enter "+colName[i]+" to: "+colValue[i].getText()+" from: "+
                          newRowValue [i] +" Changed w/o pressing Enter!");
             newRowValue [i] = colValue[i].getText();
             }
             
          }
          
          copyResult.setText(sql.update(newRowValue));
          if (newRowValue[1].equals("*new*") &&
              colName[3].equals("LastName")    )
             
          {
             select  = "Who WHERE LastName >= '"+ newRowValue[3]
                     + "' ORDER BY LastName,FirstName";
             lastRow = sqlWho.setSelect(select);
             nextWho();         
          }
          else
             refreshRowValues();

          
       }
       
       if (source == addRow)
       {
          sysout.display("Add Row Button Pressed");
          if (tbName.equals("Who"))
              newRowValue[0] = "";
          else
             // newRowValue[0] = whoID; 2003-04-05 change to always Add Who record...
          {
             tbName       =   "Who";
             sysout.display("tbName="+tbName);
             tbNames.setSelectedIndex(fileNames.length-1); // will work as long as Who is last
             for (c=0; c < colValue.length; c++)
             {
                 container.remove(colValue[c]);
                 container.remove(colLabel[c]);
                 container.remove(copyResult);
             }
             newTable();
             newRowValue[0] = "";  // set after newTable does SQL read...
 
          }
              
          newRowValue    [1] = "*new*";
          colValue[0].setText(newRowValue[0]);
          colValue[1].setText(newRowValue[1]);
          for (int i = 2; i < colName.length; i++)
          {
             newRowValue[i] = "";
             colValue[i].setText("");
             copyResult.setText("Update Fields and press Update to Add new Record");
          }
       }
       
       if (source == deleteRow)
       {
          sysout.display("Delete Row Button Pressed");     
          copyResult.setText(sql.delete(newRowValue));
          if (colName[3].equals("LastName")    )
          {
             nextWho();         
          }
       }

     }
   } // end class ButtonAL


  public static void main(String[] args)
  {
    DataUpdate DataUpdate = new DataUpdate();
    DataUpdate.init(args);
  }

  public void init(String[] parm)
  {
   sysout.syslog("syslogDataUpdate.txt");
   sysout.setNoStop();
   if (parm.length < 1)
   {
        sysout.display("DataUpdate--invalid call: requires 1 parameter");
        sysout.display("DataUpdate <dataBaseName> ");
        System.exit(4);
   }
   
   sqlWho    = new JsrSQL(parm[0]); // first init sets connection
   sql       = new JsrSQL();        // use   connection from 1st init
   fileNames = sql.getTables(parm[0]); // get fileNames for JComboBox
   //for (int i=0; i < fileNames.length; i++)
   //{
   //   fileNames[i] = fileNames[i].substring(0,1).toUpperCase()+fileNames[i].substring(1);
   //   sysout.display("TableName="+fileNames[i]);
   //}  this is now done in JsrSQL getTables method  2003-03-15
   tbNames   = new JComboBox(fileNames);

   try {        UIManager.setLookAndFeel(
            UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) { }  // set Look and Feel to Windows
        // System=Windows on Win32 systems, CrossPlatform=Metal (Java default)
        // on other systems, presumably will be that system's look and feel.
        
   frame = new JFrame("DataUpdate: SQL Table Update.");
   container  = frame.getContentPane();
   gridbag    = new GridBagLayout();
   constraint = new GridBagConstraints(); 

   frame.addWindowListener(new WindowExit());
   frame.setBounds(100,50,0,0); // offset right, offset down; size as needed.
   //sysout.display("Frame created ");


   container.setLayout(gridbag);
   constraint.fill = GridBagConstraints.HORIZONTAL; //makes all buttons as wide as possible
   //constraint.ipadx = 40; // pad horizontal w/ 40 pixels
   constraint.weightx = 1.0;  // default 0.0 let columns overlap when resized.

   tbNames.setSelectedIndex(fileNames.length-1); // will work as long as Who is last
   tbNames.addActionListener
   (new       ActionListener()
   {
      public void actionPerformed(ActionEvent e)
      {
        JComboBox cb = (JComboBox)e.getSource();
        tbName       =   (String)cb.getSelectedItem();
        sysout.display("tbName="+tbName);
        //frame.setVisible(false); make no diff.
        //container.invalidate();   "
        //container.removeAll();  // OK either rebuild all, or
                                  //    only delete labels and textFields.
        for (c=0; c < colValue.length; c++)
        {
            container.remove(colValue[c]);
            container.remove(colLabel[c]);
            container.remove(copyResult);
        }
        newTable();
      }
   }
   );  // end of JComboBox...
   
   tbNames.setToolTipText("Select Data Set to Update!!!");

   constraint.gridx = 0;
   constraint.gridy = 0;
   constraint.fill = GridBagConstraints.NONE;
   gridbag.setConstraints(tbNames, constraint);
   container.add(tbNames);  

   displayName = new JTextField("  ", 30);  
   displayName.setToolTipText("Enter new LastName to reposition!!!");
   displayName.addActionListener(parmAL);
   displayName.setFont(defaultFont);
   constraint.gridx = 1;
   constraint.gridy = 0;
   constraint.gridwidth = 4;
   gridbag.setConstraints(displayName, constraint);
   container.add(displayName);


   // defines next button   
   nextRow.addActionListener(buttonAL);
   constraint.gridwidth = 1;
   constraint.gridx = 1;
   constraint.gridy = 1;
   constraint.fill = GridBagConstraints.NONE;
   gridbag.setConstraints(nextRow, constraint);
   nextRow.setMnemonic('N');
   nextRow.setToolTipText("Next: Click here or press Alt-N for Next Person.");
   container.add(nextRow);  
   // end define next button

   // defines update button   
   updateRow.addActionListener(buttonAL);
   constraint.gridx = 2;
   constraint.gridy = 1;
   constraint.fill = GridBagConstraints.NONE;
   gridbag.setConstraints(updateRow, constraint);
   updateRow.setMnemonic('U');
   updateRow.setToolTipText("Update: Click here or press Alt-U to update Record.");
   container.add(updateRow);  
   // end define update button

   // defines add button
   addRow.addActionListener(buttonAL);
   constraint.gridx = 3;
   constraint.gridy = 1;
   constraint.fill = GridBagConstraints.NONE;
   gridbag.setConstraints(addRow, constraint);
   addRow.setMnemonic('A');
   addRow.setToolTipText("Update: Click here or press Alt-A to add Record.");
   container.add(addRow);  
   // end define add button

   // defines delete button
   deleteRow.addActionListener(buttonAL);
   constraint.gridx = 4;
   constraint.gridy = 1;
   constraint.fill = GridBagConstraints.NONE;
   gridbag.setConstraints(deleteRow, constraint);
   deleteRow.setMnemonic('D');
   deleteRow.setToolTipText("Update: Click here or press Alt-D to delete Record.");
   container.add(deleteRow);  
   // end define delete button


    
    select  = "Who ORDER BY LastName,FirstName";
    lastRow = sqlWho.setSelect(select);
    //sysout.display("lastRow="+lastRow);
    if (lastRow > 0)
    {
              sqlWho.setNextRow();
            whoID = sqlWho.getString("WhoID");
         lastName = sqlWho.getString("LastName");
        firstName = sqlWho.getString("FirstName");
        displayName.setText(lastName.trim()+", "+firstName.trim());
    }
        

   JLabel label = new JLabel("DataName: ", JLabel.RIGHT);
   constraint.gridx = 0;
   constraint.gridy = 2;
   constraint.gridwidth = 1;
   constraint.fill = GridBagConstraints.NONE; 
   gridbag.setConstraints(label, constraint);
   container.add(label);
   
   JLabel valueLabel = new JLabel("Press ENTER after EACH parameter change!!!");
   constraint.gridx = 1;
   constraint.gridy = gridy++;  
   constraint.gridwidth = 4;
   constraint.fill = GridBagConstraints.HORIZONTAL; //makes as wide as possible
   gridbag.setConstraints(valueLabel, constraint);
   valueLabel.setFont(labelFont);
   container.add(valueLabel);
   newTable();
   //displayName.requestFocus();
   //displayName.selectAll();


  }

  private void newTable()
  {
   gridy = 4;
   sysout.display("Allocating table: "+tbName);
   select  = tbName + " WHERE "+tbName+".WhoID = " + whoID;
   if (lastRow == 0) select = tbName;
   sysout.display("SELECT="+select);
   lastRow = sql.setSelect(select);
   colName = sql.getColNames();
   colSize = sql.getColDisplaySize();
   lastCol = colName.length - 1; 
   colValue = new JTextField[colName.length];
   colLabel = new JLabel    [colName.length];
   r = 0;
   if (lastRow > 0)
   {
      sql.setNextRow();
      rowValue = sql.getRowValues();
   }
   else
   {
      rowValue = new String[colName.length];
      for (c=0; c <= lastCol; c++)
      {
          rowValue[c] = "";
      }
      rowValue [1] = "*new*";
      sysout.display("Empty Database: setting "+lastCol +" + 1 row values");
      
   }
   setNewRowValue();  // when doing row Updates...
   
   for (c=0; c <= lastCol; c++)
   {
        colLabel[c] = new JLabel(colName [c] + ": ", JLabel.RIGHT );
        colLabel[c].setFont(labelFont);
        constraint.gridx = 0;
        constraint.gridy = gridy;
        constraint.gridwidth = 1;
        constraint.anchor = GridBagConstraints.EAST; // ALIGN=right
        constraint.fill = GridBagConstraints.NONE;
        gridbag.setConstraints(colLabel[c], constraint);
        container.add(colLabel[c]);
        colValue[c] = new JTextField(rowValue[c],colSize[c]+1);  // from MetaData
        colValue[c].setToolTipText("Press enter to update value!!!");
        colValue[c].addActionListener(parmAL);
        colValue[c].setFont(defaultFont);
        if ( c <  2 ) colValue[c].setEditable(false);
        constraint.gridx = 1;
        constraint.gridy = gridy++;
        constraint.gridwidth = 3;
        constraint.anchor = GridBagConstraints.WEST; // ALIGN=left
        constraint.fill = GridBagConstraints.NONE;
        //                                  .HORIZONTAL; //makes all buttons as wide as possible
        gridbag.setConstraints(colValue[c], constraint);
        container.add(colValue[c]);
   }

   

   copyResult = new JLabel(u.padLeft(" ",60),JLabel.LEFT);
   copyResult.setFont(labelFont);
   //copyResult.setFont(defaultFont);
   constraint.gridx = 1;
   constraint.gridy = gridy;
   constraint.fill = GridBagConstraints.HORIZONTAL;
   gridbag.setConstraints(copyResult, constraint);
   container.add(copyResult);
   //colValue[2].requestFocus();
   //colValue[2].selectAll();

   frame.pack(); // sets size to just as big as it needs to be.
   container.validate();
   frame.setVisible(true);
        
  }

  public void nextWho()
  {
        if (!sqlWho.setNextRow())
        {
             select  = "Who ORDER BY LastName,FirstName";
             lastRow = sqlWho.setSelect(select);
             sqlWho.setNextRow();
             // if get last Row, wrap around.    
        }
            whoID = sqlWho.getString("WhoID");
         lastName = sqlWho.getString("LastName");
        firstName = sqlWho.getString("FirstName");
        displayName.setText(lastName.trim()+", "+firstName.trim());  

        select  = tbName + " WHERE "+tbName+".WhoID = " + whoID;
        //sysout.accept("SELECT="+select);
        lastRow = sql.setSelect(select);
        //sysout.accept("lastRow="+lastRow);
        sql.setNextRow();
        refreshRowValues();
        if (copyResult != null) copyResult.setText(" ");
  }

  void refreshRowValues()
  {
        rowValue = sql.getRowValues();
                       setNewRowValue();
        sysout.display("Refreshing Row Values:" + rowValue[0] +"/"+ rowValue[1]);
        for (c=0; c <= lastCol; c++)
        {
             colValue[c].setText(rowValue[c]);
             //sysout.accept("c="+c);
        }
  }

  void setNewRowValue()
  {
    newRowValue = new String[rowValue.length];
    //sysout.display("  Values1/2/2)="+rowValue[0]+"/"+rowValue[1]+"/"+rowValue[2]+"*");
    if (rowValue[1].equals("*new*"))
    {
          if (tbName.equals("Who"))
              rowValue[0] = "";
          else
              rowValue[0] = whoID;
    }
    //sysout.display("**Values1/2/2)="+rowValue[0]+"/"+rowValue[1]+"/"+rowValue[2]+"*");
    for (int i=0; i < newRowValue.length; i++)
        newRowValue[i] = rowValue[i];
  }
  
  void closeAndExit()
  {
    sql.close();
    sysout.display("DataUpdate--Exiting");
    System.exit(0);
  }// end closeAndExit()
  
// end of class DataUpdate
}