import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DataReport {

  static final    int MAXLINES = 200;

         //JsrSQL sql = new JsrSQL();
         JsrSQL   sql;
         String   selectFrom = "";
         String    inRTFName = "";
         String   outRTFName = "";

  
  static JsrUtil u = new JsrUtil();
  JsrSysout sysout = new JsrSysout();
  JsrLineIn     in = new JsrLineIn();
  JsrLineOut   out = new JsrLineOut();
  JsrRunExec start = new JsrRunExec();

  // following are defined here so can use in Listener invoked methods.
  JCheckBox []    doFile;  
  JLabel          copyResult; 
  
  String             c = "";
  String            t0 = "";
  String            t1 = "";
  String            t2 = "";
  String  fileSep      = System.getProperty("file.separator");

  String         sqlDB = "";
  String         title = "";
  String         today = "";
  String[]      report = new String[MAXLINES];
  String[]        desc = new String[MAXLINES];
  String[]    sqlTable = new String[MAXLINES];
  String[]    sqlWhere = new String[MAXLINES];
  String[]    sqlOrder = new String[MAXLINES];
  String[]      inLine = new String[MAXLINES];

  int               eq = 0;
  int                r = -1;
  int             rMax = -1;
  int          maxLine = 0;
  int        beginLine = 0;
  int         oneCount = 0;
  int           oneEnd = 0;
  int        thisCount = 0;
  int          twoLine = 0;
  int           twoEnd = 0;
  int         twoCount = 0;
  int        threeLine = 0;
  int         threeEnd = 0;
  int       threeCount = 0;
  int          endLine = 0;
  boolean     moreRows = true;
  int        setNumber = 0;
  
  int                i = 0;
  int     firstBracket = 0;
  int      nextBracket = 0;
  int          lineIn  = 0;
  public static void main(String[] args)
  {
    DataReport DataReport = new DataReport();
    DataReport.init(args);
  }

  public void init(String[] parm)
  {
    sysout.syslog("syslogDataReport.txt");
    sysout.setNoStop();
    in.setName("ReportIn/DataReport.txt");
    while (0 < in.getNext())
    {
        t0 = in.getLine();
        lineIn++;
        //sysout.display("DataReport--"+t0);
        if (t0.length() == 0) continue;  //allow blank lines for spacing.
        eq = t0.indexOf("=");
        if (eq < 1)
        {
            sysout.display("DataReport--"+t0);
            sysout.display("DataReport--Ill formed command on line: "+ lineIn+", skipped!");
            continue;
        }
        t1 = t0.substring(0,eq);
        t2 = t0.substring(eq+1);
        //sysout.display(t1+"/"+t2);
        if (t1.equals("*db"))
                        sqlDB = t2;
        if (t1.equals("*title"))
                        title = t2;
        if (t1.equals("*today"))
                        today = t2;
        if (t1.equals("report"))
        {              r++;
                       rMax = r + 1;
                       report[r] = t2;
                       sqlTable[r] = "";
                       sqlWhere[r] = "";
                       sqlOrder[r] = "";
                       sysout.display("DataReport--report["+r+"]="+t2);
        }
                        
        if (t1.equals("desc"))
                       desc[r] = t2;
        if (t1.equals("sqlTable"))
                       sqlTable[r] = t2;
        if (t1.equals("sqlWhere"))
                       sqlWhere[r] = t2;
        if (t1.equals("sqlOrder"))
                       sqlOrder[r] = t2;


    }
    sql = new JsrSQL(sqlDB); // connect to database
    //doCommand();
    //sql.close();
    doGUI();
    

  }


  private void doCommand()
  {
    for (int i = 0; i <= r; i++)
         sysout.display("DataReport--report["+i+"]="+report[i]);
    String reply = sysout.accept("Please enter report #: ");
    while (!reply.equals("q"))
    {
        doOneReport( u.getInt(reply) );  
        for (int i = 0; i <= r; i++)
             sysout.display("DataReport--report["+i+"]="+report[i]);
        reply = sysout.accept("Please enter next report # or 'q' to quit: ");
    }

  }
  private void doGUI()
  {
   JFrame frame;
   // JCheckBox []    doFile; // accessed by Inner Class, must be defined out of method. 
   // JLabel copyResult; // define out of method so can use in Listener invoked methods.
   // Font defaultFont = new Font("Lucida Sans",Font.BOLD,18);        
   Font defaultFont = new Font("Comic Sans MS",Font.BOLD,12);        
  
    sysout.setNoStop();
   
    //  A simple WindowClosing Listener
    class WindowExit extends WindowAdapter
    {
        public void windowClosing(WindowEvent e)
        {
            Window w = e.getWindow();
            w.setVisible(false);
            w.dispose();
            sql.close();
            sysout.display("DataReport--Exiting");
            
            System.exit(0);
        }
    }
    // end class WindowExit
    // Note: this must be defined physically in the class
    //       BEFORE the first reference.  When I defined it at
    //       the end, it was not found, I moved it up here, all OK!

    
    // A simple ItemListener, showing each selection and deselection.
    // Must have name other than ItemListener
    class FileIL implements ItemListener
    {
      public void itemStateChanged(ItemEvent ex)
      {
       String item =
          ((AbstractButton)ex.getItemSelectable()).getActionCommand();
        
        boolean selected = (ex.getStateChange() == ItemEvent.SELECTED);
        //sysout.display(item+"="+selected);
        if (selected)
        {
           Object source = ex.getItemSelectable();
           for (int i=0; i < rMax; i++)
           {
              if (source == doFile[i])
                 copyResult.setText( doOneReport( i ) ); 
           }
                
        }
      }
    } // end class FileIL


    try {        UIManager.setLookAndFeel(
            UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) { }  // set Look and Feel to Windows
        // System=Windows on Win32 systems, CrossPlatform=Metal (Java default)
        // on other systems, presumably will be that system's look and feel.

    frame = new JFrame("DataReport--Select report(s) to edit");
    frame.addWindowListener(new WindowExit());
    frame.setBounds(300,10,0,0); // offset right, offset down; size as needed.
    //sysout.display("Frame created ");

    ItemListener fileIL   = new FileIL();
    Container c = frame.getContentPane();

    c.setLayout(new GridLayout(rMax+2,1));
    
    doFile = new JCheckBox[rMax];

    JLabel fileHead = new JLabel("Select File(s) to Edit...");
    c.add (fileHead);
    for (int i=0; i < rMax; i++)
    {
          doFile[i] = new JCheckBox(report[i]+": "+desc[i], false);
          doFile[i].setToolTipText("Check box to edit file");
          doFile[i].addItemListener(fileIL);
          doFile[i].setFont(defaultFont);
          c.add(  doFile[i]);
        
    }
    String line80 = u.padLeft(" ",200);
    copyResult = new JLabel(line80,JLabel.LEFT);
    //copyResult.setFont(defaultFont);
    c.add(copyResult);

    frame.pack(); // sets size to just as big as it needs to be.
    c.validate();
    frame.setVisible(true);

        
  }
  
  
  private String doOneReport(int r)
  {

    inRTFName    = report[r];
    outRTFName   = report[r];
    selectFrom   = sqlTable[r];
    if (sqlWhere[r].length() > 0)
        selectFrom += " WHERE "    + sqlWhere[r];
    if (sqlOrder[r].length() > 0)
        selectFrom += " ORDER BY " + sqlOrder[r];

    sysout.display("DataReport--SQL: "+selectFrom);
    oneCount = sql.setSelect(selectFrom);
    
    thisCount = maxLine   = oneEnd   = twoLine = twoEnd
              = threeLine = threeEnd = endLine
              = twoCount  = threeCount
              = beginLine = i = 0;

    if ( inRTFName.indexOf(".") < 1)   inRTFName+=".rtf";
    if (outRTFName.indexOf(".") < 1)  outRTFName+=".rtf";
     in.setName("ReportIn" +fileSep+ inRTFName);
    out.setName("ReportOut"+fileSep+outRTFName);
    out.setFlush(true);

    while (0 < in.getNext())
    {
       inLine[maxLine] = in.getLine();
       if (inLine[maxLine].trim().equals("[*begin]"))
       {
           beginLine = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*1end]"))
       {
           oneEnd = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*2]"))
       {
           twoLine = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*2end]"))
       {
           twoEnd = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*3]"))
       {
           threeLine = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*3end]"))
       {
           threeEnd = maxLine;
       }
       else
       if (inLine[maxLine].trim().equals("[*end]"))
       {
           endLine = maxLine;
       }
       else
       {
          maxLine++;
          if (maxLine >= MAXLINES)
          {
             sysout.display("Max#inputLines: "+ MAXLINES + " exceeded, terminating");
             System.exit(8);
          }
       }
    }
    if (threeLine > 0) threeEnd = endLine;
    sysout.display ("Max="+maxLine+" begin="+beginLine+" end="+endLine
                   +" *2="+twoLine+"/"+twoEnd+" *3="+threeLine+"/"+threeEnd);
    if  (threeLine > 0)
    {
        //twoCount   = (oneCount / 3) + 1;

        twoCount   = (oneCount / 3);
        if (twoCount * 3 > oneCount) twoCount++;  //if even division do not add 1.
        threeCount = (twoCount * 2);
        if (threeCount * 2 < oneCount) threeCount--;  //if even division do not subtract 1.

        sysout.display("Three Columns: "+ twoCount +"/"+ threeCount);
    }
    else
    if  (twoLine > 0)
    {
        twoCount   = (oneCount / 2) + 1;
        sysout.display("Two Columns: "+ twoCount);
    }

    moreRows = sql.setNextRow();  // always get first record first, put [*next] at END of line!!

    if (beginLine <= endLine)
    {
        for (i=0; i < beginLine; i++) processOneLine();

        if (twoCount > 0)
        {
            while (moreRows && thisCount < twoCount)
            {
               //sysout.display("*1 from "+ beginLine +" to "+ oneEnd);
               for (i=beginLine; i < oneEnd; i++) processOneLine();
            }
            for (i=i;        i < twoLine; i++) processOneLine();
            beginLine = i;
        }

        if (threeCount > 0)
        {
            while (moreRows && thisCount < threeCount)
            {
               //sysout.display("*2 from "+ twoLine +" to "+ twoEnd);
               for (i=twoLine; i < twoEnd; i++) processOneLine();
            }
            for (i=i;        i < threeLine; i++) processOneLine();
            beginLine = i;
        }
        while (moreRows)
        {
            //sysout.display("Processing *begin/*end set # "+ ++setNumber);
            //sysout.display("**from "+ beginLine +" to "+ endLine);
            for (i=beginLine; i < endLine; i++) processOneLine();
        }
        for (i=endLine; i < maxLine; i++) processOneLine();
    }
    else
       for (i=0; i < maxLine; i++)
       {
          processOneLine(); 
       }

    out.close();
    String returnText = "DataReport--report["+r+"]="+report[r]
                      +" processed: " + thisCount + " database rows.";
    sysout.display(returnText);
    if (thisCount > 0)
      try   {start.runExec("start ReportOut"+fileSep+outRTFName);}
      catch (Exception e) {}
    return returnText;
  }

  private void processOneLine()
  {
     //sysout.display("Line="+ i +"/"+ inLine[i]);
     t1 = inLine[i];
     t0 = "";
     firstBracket = 0;
     while (firstBracket > -1)
     {
        firstBracket = t1.indexOf("[");
        if (firstBracket < 0)
        {
            if (t0.length() == 0)
                out.setLine(t1);
            else
                out.setLine(t0+t1);
            return;
        }
        nextBracket = t1.indexOf("]");
        if (nextBracket < firstBracket)
        {
           sysout.display("Line: "+i+"=" + t1);
           sysout.accept("Line: "+i+" Malformed Bracket at: "+firstBracket+"/"+nextBracket);
            if (t0.length() == 0)
                out.setLine(t1);
            else
                out.setLine(t0+t1);
           return;
        }
        //sysout.display("Line: "+i+" Well Formed Brackets at: "+firstBracket+"/"+nextBracket);
        t2 = t1.substring(0,firstBracket);
        c  = t1.substring(firstBracket+1,nextBracket);
        t1 = t1.substring( nextBracket+1);
        //out.setLine(t2);
        t0 += t2;
        //sysout.display("Found: "+c);
        if (moreRows) // only process commands if there are more rows...
        {
           if (c.equals("*next"))
           {
               moreRows = sql.setNextRow();
               thisCount++;
               //sysout.display("Reading Record: "+thisCount);
           }
           else
           if (c.equals("*count"))
               //out.setLine(u.padLeft(oneCount,10).trim());
               t0 += u.padLeft(oneCount,10).trim();
           else
           if (c.equals("*title"))
               t0 += title;
           else
           if (c.equals("*today"))
               t0 += today;
           else
           if (c.equals("*asof"))
               t0 += u.getDateTime();
           else
           {
               //out.setLine(sql.getString(c));
               t0 += sql.getString(c);
           }
        }
      
     }
  }


}